/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio;

import filenet.vw.api.VWException;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.toolkit.design.visio.model.DocumentObject;
import filenet.vw.toolkit.design.visio.model.Page;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingFileWrapper;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingHelper;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingItem;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingLists;
import filenet.vw.toolkit.design.visio.model.reader.VisioReader;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.FileDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JDialog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class VWWizardHelper {
    private JDialog m_parentDialog = null;
    private VWDesignerCoreData m_designerCoreData = null;
    private FileDialog m_saveFileDialog = null;
    private FileDialog m_openFileDialog = null;
    private DocumentObject m_documentObject = null;
    private VWMappingFileWrapper m_mappingFileWrapper = null;
    private VWMappingHelper m_mappingHelper = null;

    public VWWizardHelper(JDialog parentDialog, VWDesignerCoreData designerCoreData) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_designerCoreData = designerCoreData;
            this.m_saveFileDialog = new FileDialog(this.m_designerCoreData.getParentFrame());
            this.m_saveFileDialog.setMode(1);
            this.m_saveFileDialog.setTitle(VWResource.s_saveStr);
            this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
            this.m_openFileDialog = new FileDialog(this.m_designerCoreData.getParentFrame());
            this.m_openFileDialog.setMode(0);
            this.m_openFileDialog.setTitle(VWResource.s_openStr);
            this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterName);
            this.m_mappingHelper = new VWMappingHelper(this.m_designerCoreData);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JDialog getParentDialog() {
        return this.m_parentDialog;
    }

    public void setVisioFile(String filePath) throws Exception {
        File tmpFile;
        String validatedFilePath = null;
        if (filePath != null && filePath.length() > 0 && (tmpFile = new File(filePath.trim())) != null && tmpFile.isFile()) {
            validatedFilePath = tmpFile.getAbsolutePath();
        }
        if (validatedFilePath == null) {
            throw new VWException("vw.toolkit.design.visio.invalidFile", "Please select a valid file.");
        }
        try {
            FileInputStream inStream = new FileInputStream(validatedFilePath);
            InputStreamReader isr = new InputStreamReader((InputStream)inStream, "UTF8");
            BufferedReader bufferedReader = new BufferedReader(isr);
            InputSource inputSource = new InputSource(bufferedReader);
            new VWXMLWrapper(inputSource, null);
        }
        catch (SAXParseException saxEx) {
            VWString parsingError = new VWString("vw.toolkit.design.visio.parsingError", "** Parsing error");
            VWString line = new VWString("vw.toolkit.design.visio.line", "line");
            String errString = parsingError + ", " + line + " " + saxEx.getLineNumber() + ", uri " + saxEx.getSystemId() + "\n" + "   " + saxEx.getMessage();
            VWException theException = new VWException("vw.toolkit.design.visio.XMLReadError_1", "Error reading file: {0}.", errString);
            theException.setCause(saxEx);
            throw theException;
        }
        catch (VWException vwex) {
            VWException theException = new VWException("vw.toolkit.design.visio.XMLReadError_2", "Error reading file: {0}", vwex.getMessage());
            theException.setCause(vwex.getCause());
            throw theException;
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.toolkit.design.visio.XMLReadError_3", "Error reading file: {0}", ex.getMessage());
            theException.setCause(ex);
            throw theException;
        }
        VisioReader reader = new VisioReader();
        this.m_documentObject = reader.readDocument(filePath);
        if (this.m_documentObject != null) {
            this.m_documentObject.setFileName(filePath);
        }
    }

    public boolean getShouldRenameNewWorkflows() {
        return this.m_mappingHelper.getShouldRenameNewWorkflows();
    }

    public void setShouldRenameNewWorkflows(boolean bShouldRenameNewWorkflows) {
        this.m_mappingHelper.setShouldRenameNewWorkflows(bShouldRenameNewWorkflows);
    }

    public int getLocationPadding() {
        return this.m_mappingHelper.getLocationPadding();
    }

    public void setLocationPadding(int nlocationPadding) {
        this.m_mappingHelper.setLocationPadding(nlocationPadding);
    }

    public String[] getPageNames() {
        Vector pages;
        String[] names = null;
        if (this.m_documentObject != null && (pages = this.m_documentObject.getPages()) != null && pages.size() > 0) {
            names = new String[pages.size()];
            for (int nIndex = 0; nIndex < pages.size(); ++nIndex) {
                Page page = (Page)pages.elementAt(nIndex);
                if (page == null) continue;
                names[nIndex] = new String(page.getNameU());
            }
        }
        return names;
    }

    public String[] getSelectedPageNames() {
        Vector pages;
        if (this.m_documentObject != null && (pages = this.m_documentObject.getPages()) != null && pages.size() > 0) {
            Vector<String> names = new Vector<String>();
            for (int nIndex = 0; nIndex < pages.size(); ++nIndex) {
                Page page = (Page)pages.elementAt(nIndex);
                if (page == null || !page.isSelected()) continue;
                names.addElement(new String(page.getNameU()));
            }
            if (names.size() > 0) {
                Object[] nameAry = new String[names.size()];
                names.copyInto(nameAry);
                return nameAry;
            }
        }
        return null;
    }

    public void setSelectedPageNames(String[] names) {
        Vector pages;
        if (this.m_documentObject != null && (pages = this.m_documentObject.getPages()) != null && pages.size() > 0) {
            for (int nIndex = 0; nIndex < pages.size(); ++nIndex) {
                Page page = (Page)pages.elementAt(nIndex);
                if (page == null) continue;
                boolean bSelected = false;
                if (names != null && names.length > 0) {
                    for (int j = 0; j < names.length; ++j) {
                        if (VWStringUtils.compare(page.getNameU(), names[j]) != 0) continue;
                        bSelected = true;
                        break;
                    }
                }
                page.setSelected(bSelected);
            }
        }
    }

    public VWMappingLists getMappingLists() throws Exception {
        VWMappingFileWrapper mappingFileWrapper = this.getMappingFileWrapper(false);
        if (mappingFileWrapper != null) {
            return mappingFileWrapper.getMappingLists();
        }
        return null;
    }

    public VWMappingItem[] getMappingItems() throws Exception {
        Vector pages;
        if (this.m_documentObject != null && (pages = this.m_documentObject.getPages()) != null && pages.size() > 0) {
            VWMappingFileWrapper mappingFileWrapper = this.getMappingFileWrapper(true);
            mappingFileWrapper.resetMappedShapes();
            for (int nIndex = 0; nIndex < pages.size(); ++nIndex) {
                Vector shapes;
                Page page = (Page)pages.elementAt(nIndex);
                if (page == null || !page.isSelected() || (shapes = page.getShapes()) == null) continue;
                for (int j = 0; j < shapes.size(); ++j) {
                    Shape shape = (Shape)shapes.elementAt(j);
                    mappingFileWrapper.addShape(shape);
                }
            }
            return mappingFileWrapper.getMappingItems();
        }
        return null;
    }

    public void openLocalMappingFile() throws Exception {
        this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterName);
        this.m_openFileDialog.setVisible(true);
        String fileToOpen = this.m_openFileDialog.getFile();
        if (fileToOpen != null) {
            String filePath = this.m_openFileDialog.getDirectory() + fileToOpen;
            this.m_mappingFileWrapper.loadShapeMappingFromFile(filePath);
            this.updateSavedFilePath(filePath);
        }
    }

    public void saveAsNewMappingFile() {
        try {
            String savedDir = this.m_saveFileDialog.getDirectory();
            String savedFile = this.m_saveFileDialog.getFile();
            this.m_saveFileDialog.setVisible(true);
            if (this.m_saveFileDialog.getFile() == null) {
                this.m_saveFileDialog.setDirectory(savedDir);
                this.m_saveFileDialog.setFile(savedFile);
            } else {
                this.saveShapeMappingToLocalFile();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.s_fileSaveErrorTitle, 1);
        }
    }

    public void loadDefaultMappingFile() throws Exception {
        this.m_mappingFileWrapper.loadDefaultMappingFile();
        this.updateSavedFilePath(null);
    }

    public String getMappingFileName() {
        return this.m_mappingFileWrapper.getFileName();
    }

    public String[] createWorkflowProcesses() {
        return this.m_mappingHelper.createWorkflowProcesses(this.m_documentObject, this.m_mappingFileWrapper);
    }

    public VWWorkflowCollectionDefinition getNewWorkflows() {
        return this.m_mappingHelper.getNewWorkflows();
    }

    private VWMappingFileWrapper getMappingFileWrapper(boolean bLoadFile) throws Exception {
        if (this.m_mappingFileWrapper == null) {
            this.m_mappingFileWrapper = new VWMappingFileWrapper(this.m_designerCoreData);
        }
        if (bLoadFile && !this.m_mappingFileWrapper.isInitialized()) {
            String filePath = this.getSavedFilePath();
            if (filePath != null && filePath.length() > 0) {
                try {
                    File mappingFile = new File(filePath);
                    if (mappingFile != null && mappingFile.exists()) {
                        this.m_mappingFileWrapper.loadShapeMappingFromFile(filePath);
                        this.m_openFileDialog.setFile(mappingFile.getName());
                        this.m_openFileDialog.setDirectory(mappingFile.getParent());
                        this.m_saveFileDialog.setFile(mappingFile.getName());
                        this.m_saveFileDialog.setDirectory(mappingFile.getParent());
                    } else {
                        VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.s_fileNotFound.toString(filePath), VWResource.s_fileOpenErrorTitle, 1);
                        this.updateSavedFilePath(null);
                        this.m_mappingFileWrapper.loadDefaultMappingFile();
                    }
                    return this.m_mappingFileWrapper;
                }
                catch (Exception ex) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.s_fileOpenErrorTitle, 1);
                    this.updateSavedFilePath(null);
                }
            }
            this.m_mappingFileWrapper.loadDefaultMappingFile();
        }
        return this.m_mappingFileWrapper;
    }

    private String getSavedFilePath() {
        try {
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                return (String)userInfo.getFieldValue("designer_mapping_file_location");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void updateSavedFilePath(String filePath) {
        try {
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                userInfo.setFieldValue("designer_mapping_file_location", filePath);
                userInfo.save();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void saveShapeMappingToLocalFile() {
        try {
            String filePath = this.m_saveFileDialog.getDirectory() + this.m_saveFileDialog.getFile();
            this.m_mappingFileWrapper.saveShapeMappingToFile(filePath);
            this.m_openFileDialog.setDirectory(this.m_saveFileDialog.getDirectory());
            this.m_openFileDialog.setFile(this.m_saveFileDialog.getFile());
            this.updateSavedFilePath(filePath);
        }
        catch (SecurityException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.s_fileSecurityErrorTitle, 1);
            this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.s_fileSaveErrorTitle, 1);
            this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
        }
    }
}

